unit MainImgTools;
(*
   ========================================================================
      "ImgTools"
        (   ).
   ========================================================================
         .
         .
   ========================================================================
   ()  ,    , , .
   ========================================================================
*)

interface

uses
  //  
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtDlgs, StdCtrls, ComCtrls, ExtCtrls, Buttons, ImgList, Menus, jpeg, Math,
  //     "ImgTools"
  //   " "
  MainData, EngineMainData01,
  //    " "
  EngineImgSelector01,
  EngineImgService01,
  EngineImgService02,  //   (, )
  EngineImgLoadSave01,
  EngineExportDlg01, EngineImportDlg01,
  //   ""
  EngineImgScale01,    //   ()
  EngineImgScaleDialog01,
  //   " "
  DFilterMain, DFilterMainData01, DFilterService01,
  //   ""
  GistogramMainData01, GistogramMain, GistogramService03,
  //  
  AboutMain, ToolWin;

//========================================================================
//      "ImgTools" (   )
//========================================================================
type
  TFormImgTools = class(TForm)
    Panel2: TPanel;
    StatusBar1: TStatusBar;
    ProgressBar1: TProgressBar;
    MainMenu1: TMainMenu;
    MMFile: TMenuItem;
    N2: TMenuItem;
    N4: TMenuItem;
    MMOp: TMenuItem;
    MMGistogram: TMenuItem;
    MMDFilter: TMenuItem;
    MMAbout: TMenuItem;
    ImageList1: TImageList;
    MMExit: TMenuItem;
    OpenDialog1: TOpenDialog;
    SaveDialog1: TSaveDialog;
    stxtPointColor: TStaticText;
    MMEdit: TMenuItem;
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    TabSheet3: TTabSheet;
    MMLoadToSrc: TMenuItem;
    MMLoadToDest: TMenuItem;
    MMImportToSrc: TMenuItem;
    MMSaveFromSrc: TMenuItem;
    MMSaveFromDest: TMenuItem;
    MMExportFromSrc: TMenuItem;
    Clipboard1: TMenuItem;
    MMClipCopySRC: TMenuItem;
    MMClipPasteSRC: TMenuItem;
    MMCopyImage: TMenuItem;
    MMCopySrcToDest: TMenuItem;
    MMCopyDestToSrc: TMenuItem;
    MMMinimize: TMenuItem;
    MMMinSrc: TMenuItem;
    MMMinDest: TMenuItem;
    N1: TMenuItem;
    N3: TMenuItem;
    N5: TMenuItem;
    MMCropping: TMenuItem;
    N6: TMenuItem;
    PanelRotate: TPanel;
    ToolBarRotate: TToolBar;
    TBRSep1: TToolButton;
    LbTBRMirror: TLabel;
    TBRMirrorTD: TToolButton;
    TBRMirrorLR: TToolButton;
    LbTBRRot90: TLabel;
    TBRRot90Minus: TToolButton;
    TBRRot90Plus: TToolButton;
    LbTBRAngle: TLabel;
    EdiAngle: TEdit;
    LbTBRFon: TLabel;
    TBRRunAngle: TToolButton;
    Label2: TLabel;
    PanelSrcImg: TPanel;
    ScrollBoxSrcImg: TScrollBox;
    ImageMain: TImage;
    PanelTrgImg: TPanel;
    ScrollBoxTrgImg: TScrollBox;
    TargetImage: TImage;
    MMView: TMenuItem;
    MMWheelV: TMenuItem;
    MMRulerSmoothly: TMenuItem;
    N9: TMenuItem;
    MMPRotate: TMenuItem;
    sttxtRotationCentre: TStaticText;
    MMShowHint: TMenuItem;
    sttxtAttention: TStaticText;
    TimerAttention: TTimer;
    MMAutoCorr: TMenuItem;
    MMGistogramFull: TMenuItem;
    sttxtTBRotColor: TStaticText;
    ColorDialog1: TColorDialog;
    Label1: TLabel;
    Label3: TLabel;
    TBRZoomForm: TToolButton;
    TBRZoomPlus: TToolButton;
    TrBarZoom: TTrackBar;
    sttxtZoomValue: TStaticText;
    MMScale: TMenuItem;
    MMToGray: TMenuItem;
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure MMAboutClick(Sender: TObject);
    procedure MMDFilterClick(Sender: TObject);
    procedure MMSaveFromSrcClick(Sender: TObject);
    procedure MMSaveFromDestClick(Sender: TObject);
    procedure MMExportFromSrcClick(Sender: TObject);
    procedure MMLoadToSrcClick(Sender: TObject);
    procedure MMLoadToDestClick(Sender: TObject);
    procedure MMImportToSrcClick(Sender: TObject);
    procedure MMClipCopySRCClick(Sender: TObject);
    procedure MMClipPasteSRCClick(Sender: TObject);
    procedure MMCopySrcToDestClick(Sender: TObject);
    procedure MMCopyDestToSrcClick(Sender: TObject);
    procedure MMCroppingClick(Sender: TObject);
    procedure MMMinSrcClick(Sender: TObject);
    procedure MMMinDestClick(Sender: TObject);
    procedure MMExitClick(Sender: TObject);
    procedure TBRRunAngleClick(Sender: TObject);
    procedure TBRMirrorTDClick(Sender: TObject);
    procedure TBRMirrorLRClick(Sender: TObject);
    procedure TBRRot90MinusClick(Sender: TObject);
    procedure TBRRot90PlusClick(Sender: TObject);
    procedure ScrollBoxSrcImgMouseWheel(Sender: TObject; Shift: TShiftState;
      WheelDelta: Integer; MousePos: TPoint; var Handled: Boolean);
    procedure ScrollBoxTrgImgMouseWheel(Sender: TObject; Shift: TShiftState;
      WheelDelta: Integer; MousePos: TPoint; var Handled: Boolean);
    procedure PanelSrcImgMouseMove(Sender: TObject; Shift: TShiftState;
      X, Y: Integer);
    procedure PanelTrgImgMouseMove(Sender: TObject; Shift: TShiftState;
      X, Y: Integer);
    procedure MMWheelVClick(Sender: TObject);
    procedure MMRulerSmoothlyClick(Sender: TObject);
    procedure MMPRotateClick(Sender: TObject);
    procedure MMShowHintClick(Sender: TObject);
    procedure PageControl1Change(Sender: TObject);
    procedure TimerAttentionTimer(Sender: TObject);
    procedure MMAutoCorrClick(Sender: TObject);
    procedure MMGistogramFullClick(Sender: TObject);
    procedure sttxtTBRotColorClick(Sender: TObject);
    procedure TBRZoomFormClick(Sender: TObject);
    procedure TrBarZoomChange(Sender: TObject);
    procedure TBRZoomPlusClick(Sender: TObject);
    procedure sttxtZoomValueClick(Sender: TObject);
    procedure MMScaleClick(Sender: TObject);
    procedure MMToGrayClick(Sender: TObject);
  private
     //-------------------------------------------
     //   
     procedure ShowAppTitul(RqCtrlPageInd : byte);
     //   Image
     procedure ClearImgDesc(RqImg : TImage);
     //  StatusBar1
     procedure ClearStatusBar();
     //-------------------------------------------
     //   -   
     procedure SelectBeg (Sender : TObject;
                          Shift: TShiftState; BegPoint, EndPoint : TPoint);
     //   -   
     procedure SelectChange (Sender : TObject;
                             Shift : TShiftState; BegPoint, EndPoint : TPoint);
     //   -   
     procedure SelectEnd (Sender : TObject; Shift : TShiftState;
                          BegPoint, EndPoint : TPoint);
     //     
     function GetRqAngle() : extended;
     //-------------------------------------------
     //    StatusBar1.Panels[3]   Attention!
     procedure ShowAttention(LampOn    : boolean;
                             LampColor : TColor;
                             Msg : string);
     //    
     procedure RunZoomForm();
  public
    { Public declarations }
  end;

var
  FormImgTools: TFormImgTools;

// ========================================================================
implementation
{$R *.DFM}
// ========================================================================

// ========================================================================
//
//          (  .\EngineG01 )
//            
//
// ========================================================================

// ========================================================================
//    
// ========================================================================
//  ( CLIPBOARD)  ( ) 
var poImgLS : TLoadsaveImage;

//   ( )
var RegionSelector : TRegionSelector;

var //    
    WBegPoint      : TPoint;   //  
    WEndPoint      : TPoint;   //  

var // Image -      
    RotateRow      : integer;
    RotateCol      : integer;

// ========================================================================
//   
// ========================================================================
//    
function GetApplicationDirectory() : string;
begin
   Result := Application.ExeName;
   Result := ExtractFileDir(Result);
end;
// ------------------------------------------------------------------------
// 29.03.2014
//   StatusBar 
procedure TFormImgTools.ClearStatusBar();
begin
  stxtPointColor.Color := StatusBar1.Color;  //    
  TimerAttention.Enabled := False;           //   Attention
  sttxtAttention.Color := StatusBar1.Color;  //   Attention
  StatusBar1.Panels[1].Text := '';
  StatusBar1.Panels[3].Text := '';

end;
// ------------------------------------------------------------------------
// 06.03.2013
//       
procedure TFormImgTools.ShowAppTitul(RqCtrlPageInd : byte);
var WDesc : TImageDesc;
begin
   case RqCtrlPageInd of
   0 : begin
          if PageControl1.TabIndex <> 0
          then PageControl1.TabIndex := 0;
          if ImageMain.Tag <> 0
          then begin
            WDesc := pointer(ImageMain.Tag);
            Self.Caption := AppTitul
                            + '    : '
                            + ExtractFileName(WDesc.ImageFileName);
          end
          else Self.Caption := AppTitul;
          //      
          ScrollBoxSrcImg.SetFocus;
       end;
   1  : begin
          if PageControl1.TabIndex <> 1
          then PageControl1.TabIndex := 1;
          if TargetImage.Tag <> 0
          then begin
            WDesc := pointer(TargetImage.Tag);
            Self.Caption := AppTitul
                            + '    : '
                            + ExtractFileName(WDesc.ImageFileName);
          end
          else Self.Caption := AppTitul;
          //       
          ScrollBoxTrgImg.SetFocus;
       end;
   else Self.Caption := AppTitul;
   end;
end;
// ------------------------------------------------------------------------
// 06.03.2013
//   Image
procedure TFormImgTools.ClearImgDesc(RqImg : TImage);
var WDesc : TImageDesc;
begin
   if RqImg.Tag <> 0
   then begin
     try
       WDesc := pointer(RqImg.Tag);
       WDesc.ImageFileName := 'NoName';
       WDesc.FileExtCode := 0;
       WDesc.FilePixCode := pf24bit;
     except end;
   end;
end;
// ------------------------------------------------------------------------
// 06.03.2013
//   
procedure TFormImgTools.PageControl1Change(Sender: TObject);
begin
  //       
  ShowAppTitul(PageControl1.TabIndex);
end;

// ========================================================================
//       
//     unit MainData
// ========================================================================
// 
procedure TFormImgTools.FormCreate(Sender: TObject);
begin
  //   
  Caption := AppTitul;
  //    
  AppDirectory := GetApplicationDirectory();
  //    /  
  if not Assigned(poImgLS)
  then begin
    poImgLS := TLoadsaveImage.Create (ProgressBar1, StatusBar1.Panels[3]);
    //     
    poImgLS.wForm := FormImgTools;
    //    Images
    poImgLS.SetImageDescriptor(ImageMain, 'NoName', FileFormatUnkn, pfCustom);
    poImgLS.SetImageDescriptor(TargetImage, 'NoName', FileFormatUnkn, pfCustom);
  end;
  //  -
  if not Assigned(RegionSelector)
  then begin
     RegionSelector := TRegionSelector.Create(ImageMain);
     RegionSelector.ReSetRegionMode(rmRegionOnly);
     RegionSelector.RqShape := dtRectangle;
     RegionSelector.OnSelectBeg := SelectBeg;
     RegionSelector.OnSelectChange := SelectChange;
     RegionSelector.OnSelectEnd := SelectEnd;
     RegionSelector.RegionVisible(False);
  end;
  //  Images
  ClearImage (ImageMain,   ScrollBoxSrcImg.Color);
  ClearImage (TargetImage, ScrollBoxTrgImg.Color);
  //      Image
  pImgeMain     := ImageMain;    // Image  
  pImageTarget  := TargetImage;  // Image  
  //   PageControl  
  pPageControlMain := PageControl1;
end; // of procedure
// ------------------------------------------------------------------------
// 
procedure TFormImgTools.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  if Assigned(poImgLS)
  then begin
    poImgLS.Free;
    poImgLS := nil;
  end;
  if Assigned(RegionSelector)
  then begin
    RegionSelector.Free;
    RegionSelector := nil;
  end;
end; // of procedure

// ========================================================================
//   " "
// ========================================================================
//    
procedure TFormImgTools.MMAboutClick(Sender: TObject);
begin
   FormAbout.ShowModal;
end;

// ========================================================================
//  ( CLIPBOARD)  , 
// ========================================================================
//     JPEG  BMP   
procedure TFormImgTools.MMLoadToSrcClick(Sender: TObject);
begin

  Self.Refresh;
  if Assigned(poImgLS)
  then begin
    ShowAttention(True, clLime, '    ');
    //   ,   BitMap  ImgTabBGR
    if poImgLS.LoadImgFromFile(ImageMain)
    then ImageToImgTab (ImageMain, Addr(SrcImgTabBGR), ProgressBar1);
    //  
    ShowAppTitul(0);  //   
  end;
  ShowAttention(False, clLime, '');
end;
// ------------------------------------------------------------------------
//     JPEG  BMP   
procedure TFormImgTools.MMLoadToDestClick(Sender: TObject);
begin
  Self.Refresh;
  if Assigned(poImgLS)
  then begin
    ShowAttention(True, clLime, '    ');
    //   ,   BitMap  ImgTabBGR
    if poImgLS.LoadImgFromFile(TargetImage)
    then ImageToImgTab (TargetImage, Addr(TrgImgTabBGR), ProgressBar1);
    //  
    ShowAppTitul(1);  //   
  end;
  ShowAttention(False, clLime, '');
end;
// ------------------------------------------------------------------------
//  ()    Clipboard
procedure TFormImgTools.MMClipPasteSRCClick(Sender: TObject);
begin
  ClearStatusBar();
  if Assigned(poImgLS)
  then begin
    //   ,   BitMap  ptITabBGR^
    if poImgLS.PasteClipboardToImage(ImageMain)
    then ImageToImgTab (ImageMain, Addr(SrcImgTabBGR), ProgressBar1);
    //  
    ShowAppTitul(0);  //   
  end;
end;
// ------------------------------------------------------------------------
//     txt- 
procedure TFormImgTools.MMImportToSrcClick(Sender: TObject);
begin
  ClearStatusBar();
  EngineImportDlg01.ImportTxtDialog.ShowModal;
  //     Image
  ImgTabToImage(Addr(SrcImgTabBGR), ImageMain, ProgressBar1);
  //  
  ClearImgDesc(ImageMain); //   Image
  ShowAppTitul(0);         //   
end;

// ========================================================================
//  ( CLIPBOARD)  , 
// ========================================================================
//     JPEG (  )
//   BMP
procedure TFormImgTools.MMSaveFromSrcClick(Sender: TObject);
begin
 ClearStatusBar();
 if Assigned(poImgLS)
  then begin
    poImgLS.JpegQuality := 100;      // JPEG   
    poImgLS.SaveImgToFile(ImageMain);
    ShowAppTitul(0);         //   
  end;
end;
// ------------------------------------------------------------------------
//     JPEG (  )
//   BMP
procedure TFormImgTools.MMSaveFromDestClick(Sender: TObject);
begin
 ClearStatusBar();
 if Assigned(poImgLS)
  then begin
    poImgLS.JpegQuality := 100;      // JPEG   
    poImgLS.SaveImgToFile(TargetImage);
    ShowAppTitul(1);         //   
  end;
end;
// ------------------------------------------------------------------------
//     Clipboard
procedure TFormImgTools.MMClipCopySRCClick(Sender: TObject);
begin
  ClearStatusBar();
  if Assigned(poImgLS)
  then begin
    poImgLS.CopyImageToClipboard(ImageMain);
  end;
end;
// ------------------------------------------------------------------------
//     txt - 
procedure TFormImgTools.MMExportFromSrcClick(Sender: TObject);
begin
  EngineExportDlg01.ExportTxtDialog.ShowModal;
end;

// ========================================================================
//          
// ========================================================================
//  ()  
procedure TFormImgTools.MMMinSrcClick(Sender: TObject);
begin
  ClearStatusBar();
  //   Bitmap  Image
  MimimizeBitMap (ImageMain.Picture.Bitmap);
  //  Image
  ClearImage (ImageMain, ScrollBoxSrcImg.Color);
  //    
  SetLength(SrcImgTabBGR, 0);
  //  
  ClearImgDesc(ImageMain); //   Image
  ShowAppTitul(0);         //   
end;
// ------------------------------------------------------------------------
//  ()  
procedure TFormImgTools.MMMinDestClick(Sender: TObject);
begin
  ClearStatusBar();
  //   Bitmap  Image
  MimimizeBitMap (TargetImage.Picture.Bitmap);
  //  Image
  ClearImage (TargetImage, ScrollBoxSrcImg.Color);
  //    
  SetLength(TrgImgTabBGR, 0);
  //  
  ClearImgDesc(TargetImage); //   Image
  ShowAppTitul(1);           //   
end;

// ========================================================================
//       
// ========================================================================
procedure TFormImgTools.MMCopySrcToDestClick(Sender: TObject);
begin
  ClearStatusBar();
  //   SrcImgTabBGR   TrgImgTabBGR
  TabBGRtoTabBGR (Addr(SrcImgTabBGR), Addr(TrgImgTabBGR));
  //     Image
  ImgTabToImage(Addr(TrgImgTabBGR), TargetImage, ProgressBar1);
  //  
  ClearImgDesc(TargetImage); //   Image
  ShowAppTitul(1);           //   
end;
// ------------------------------------------------------------------------
procedure TFormImgTools.MMCopyDestToSrcClick(Sender: TObject);
begin
  ClearStatusBar();
  //   SrcImgTabBGR   TrgImgTabBGR
  TabBGRtoTabBGR (Addr(TrgImgTabBGR), Addr(SrcImgTabBGR));
  //     Image
  ImgTabToImage(Addr(SrcImgTabBGR), ImageMain, ProgressBar1);
  //  
  ClearImgDesc(ImageMain); //   Image
  ShowAppTitul(0);         //   
end;

// ========================================================================
//       
// ========================================================================
//   -   
procedure TFormImgTools.SelectBeg (Sender : TObject;
                 Shift: TShiftState; BegPoint, EndPoint : TPoint);
var ColorByte : TColorByte;
begin
 with BegPoint
 do begin
    WBegPoint := BegPoint;    //   
    stxtPointColor.Color := ImageMain.Canvas.Pixels[X,Y];
    ColorByte := SplitRGB(stxtPointColor.Color);
    StatusBar1.Panels[1].Text := Format('  XY : (%d, %d)', [X, Y])
                              + '  RGB('
                              + IntToStr(ColorByte.R) + ','
                              + IntToStr(ColorByte.G) + ','
                              + IntToStr(ColorByte.B) + ')';
    //    
    if PanelRotate.Visible
    then begin
       RotateRow := Y;
       RotateCol := X;
    end else begin
       RotateRow := 0;
       RotateCol := 0;
    end;
    //    
    sttxtRotationCentre.Caption := ' R, C = '
                   + IntToStr(RotateRow) + ', ' + IntToStr(RotateCol);
    //   
    StatusBar1.Panels[3].Text := '';
 end;
end;
// ------------------------------------------------------------------------
//   -   
procedure TFormImgTools.SelectChange (Sender : TObject;
                 Shift : TShiftState; BegPoint, EndPoint : TPoint);
begin
    with EndPoint do
    StatusBar1.Panels[3].Text := Format('   XY : (%d, %d)', [X, Y]);
end;
// ------------------------------------------------------------------------
//   -   
procedure TFormImgTools.SelectEnd (Sender : TObject;
                 Shift : TShiftState; BegPoint, EndPoint : TPoint);
var NRect : TRect;
begin
  WEndPoint := EndPoint;            //   
  //      TRect
  NRect := NoarmalRect (WBegPoint, WEndPoint);
  WBegPoint := NRect.TopLeft;       //  
  WEndPoint := NRect.BottomRight;   //  
end;

// ========================================================================
//
//           (  .\DFilter )
//                
//
// ========================================================================
//   -  
procedure TFormImgTools.MMDFilterClick(Sender: TObject);
var WRect : Trect;
begin
   if not EqualPoints(WBegPoint, WEndPoint)
   then begin
      ClearStatusBar();
      //  
      RegionSelector.RegionVisible(False);
      //------------------------------------
      WRect := Rect(WBegPoint, WEndPoint);
      //    ImgTabSrc     Rectangle
      SelectedToImgTab (Addr(SrcImgTabBGR),   //  ImgTab
                        WRect,                //  
                        Addr(ArrFragSrcBGR)   // ImgTab 
                        );
       //     Image ( )
       ImgTabToImage(Addr(ArrFragSrcBGR),
                     FormDFilter.ImgTestSource,
                     ProgressBar1);
      //------------------------------------
      flgFiltrApply := False;          //    
      // ===================================
      //   -   (unit DFilterDialog01)
      FormDFilter.ShowModal;
      // ===================================
      //   
      WBegPoint := WEndPoint;
      //   
      ClearStatusBar();
      //  
      if flgFiltrApply
      then ClearImgDesc(TargetImage);  //   Image
      ShowAppTitul(1);                 //   
   end
   else
     ShowAttention(True,
                   clYellow,
                   '   '
                 + '   ');
end; // of procedure

// ========================================================================
// ========================================================================
//  ,   (   )
//        EngineImgService02
//         
//   
// ========================================================================
// ========================================================================
//    
procedure TFormImgTools.MMCroppingClick(Sender: TObject);
var WRect : Trect;
begin
   if not EqualPoints(WBegPoint, WEndPoint)
   then begin
      //  
      RegionSelector.RegionVisible(False);
      //------------------------------------
      WRect := Rect(WBegPoint, WEndPoint);
      //    ImgTabSrc     Rectangle
      SelectedToImgTab (Addr(SrcImgTabBGR),   //  ImgTab
                        WRect,                //  
                        Addr(TrgImgTabBGR)    // ImgTab 
                        );
       //     Image
      ImgTabToImage(Addr(TrgImgTabBGR), TargetImage, ProgressBar1);
      //   
      WBegPoint := WEndPoint;
      //   
      ClearStatusBar();
      //  
      ClearImgDesc(TargetImage);   //   Image
      ShowAppTitul(1);             //   
   end
   else begin
     StatusBar1.Panels[3].Text := '   '
                                + '   ';
   end;
end;
// ------------------------------------------------------------------------
// 03.03.2013
//  Top-Bottom
procedure TFormImgTools.TBRMirrorTDClick(Sender: TObject);
begin
  //    BGR -  (V -  )
  MirrorToTrgArr (Addr(SrcImgTabBGR), 'V', Addr(TrgImgTabBGR), ProgressBar1);
  //     Image
  ImgTabToImage(Addr(TrgImgTabBGR), TargetImage, ProgressBar1);
  //  
  ClearImgDesc(TargetImage); //   Image
  ShowAppTitul(1);           //   
end;
// ------------------------------------------------------------------------
// 03.03.2013
//  Left-Right
procedure TFormImgTools.TBRMirrorLRClick(Sender: TObject);
begin
  //    BGR -  (H -  )
  MirrorToTrgArr (Addr(SrcImgTabBGR), 'H', Addr(TrgImgTabBGR), ProgressBar1);
  //     Image
  ImgTabToImage(Addr(TrgImgTabBGR), TargetImage, ProgressBar1);
  //  
  ClearImgDesc(TargetImage); //   Image
  ShowAppTitul(1);           //   
end;
// ------------------------------------------------------------------------
// 02.03.2013
//    90  (  )
procedure TFormImgTools.TBRRot90MinusClick(Sender: TObject);
begin
   ClearStatusBar();
   //      90 
   Rotate90PlusMinus(Addr(SrcImgTabBGR), '-', Addr(TrgImgTabBGR), ProgressBar1);
   //     Image
  ImgTabToImage(Addr(TrgImgTabBGR), TargetImage, ProgressBar1);
  //  
  ClearImgDesc(TargetImage); //   Image
  ShowAppTitul(1);           //   
end;
// ------------------------------------------------------------------------
// 02.03.2013
//    90  (  )
procedure TFormImgTools.TBRRot90PlusClick(Sender: TObject);
begin
   ClearStatusBar();
   //      90 
   Rotate90PlusMinus(Addr(SrcImgTabBGR), '+', Addr(TrgImgTabBGR), ProgressBar1);
   //     Image
  ImgTabToImage(Addr(TrgImgTabBGR), TargetImage, ProgressBar1);
  //  
  ClearImgDesc(TargetImage); //   Image
  ShowAppTitul(1);           //   
end;

// ------------------------------------------------------------------------
// 01.03.2013
//     
function TFormImgTools.GetRqAngle() : extended;
var wAngle : extended;
begin
   Result := 0;
   //         
   if ProStrToFloat (EdiAngle.Text,  wAngle)
   then begin
      if (wAngle >= -89.9) and (wAngle <= 89.9)
      then Result := wAngle
      else MessageDlg('       '
                    +   #13#10
                    + '    (-89,9 .. 89,9)'
                    +   #13#10
                    + '    ... ',
                    mtWarning, [mbOk], 0);
   end;
end;
// ------------------------------------------------------------------------
//     
// 26.02.2013
procedure TFormImgTools.TBRRunAngleClick(Sender: TObject);
var wAngle : extended;
begin
   wAngle := GetRqAngle();
   if Abs(wAngle) > 0
   then begin
      //    RotateRow, RotateCol
      // (   SelectBeg)
      //    
      RotateForTabBGR (Addr(SrcImgTabBGR),
                       RotateRow,
                       RotateCol,
                       wAngle,                  //   
                       sttxtTBRotColor.Color,   //   
                       Addr(TrgImgTabBGR),
                       ProgressBar1);
      //     Image
      ImgTabToImage(Addr(TrgImgTabBGR), TargetImage, ProgressBar1);
      //  
      ClearImgDesc(TargetImage); //   Image
      ShowAppTitul(1);           //   
   end;
end;
// ------------------------------------------------------------------------
// 22.04.2014
//       
procedure TFormImgTools.sttxtTBRotColorClick(Sender: TObject);
begin
    if ColorDialog1.Execute
    then sttxtTBRotColor.Color := ColorDialog1.Color;
end;

// ------------------------------------------------------------------------
//      
// ------------------------------------------------------------------------
// 22.04.2014  
//  -      
procedure TFormImgTools.MMPRotateClick(Sender: TObject);
begin
  PageControl1.TabIndex := 0;  //   
  if MMPRotate.Checked
  then PanelRotate.Visible := True
  else PanelRotate.Visible := False;
end;

// ========================================================================
//      
// ========================================================================

// ========================================================================
//
//        3.3
//
// ========================================================================

// ========================================================================
//  
// ========================================================================
//    (Hints)
procedure TFormImgTools.MMShowHintClick(Sender: TObject);
begin
  MMShowHint.Checked := not MMShowHint.Checked;
  Application.ShowHint := MMShowHint.Checked;
  if Application.ShowHint
  then StatusBar1.Panels[3].Text := '   '
  else StatusBar1.Panels[3].Text := '   ';
end;
// ========================================================================
//    
// ========================================================================
procedure TFormImgTools.MMExitClick(Sender: TObject);
begin
  Close;
end;

// ========================================================================
//    ScrollBox  
// ========================================================================
// 01.03.2013
//     
procedure TFormImgTools.ScrollBoxSrcImgMouseWheel(Sender: TObject;
  Shift: TShiftState; WheelDelta: Integer; MousePos: TPoint;
  var Handled: Boolean);
begin
  if Abs(WheelDelta) > 0
  then begin
    if MMWheelV.Checked
    then with ScrollBoxSrcImg.VertScrollBar
         do begin Position := Position - 3 * Sign(WheelDelta); end
    else with ScrollBoxSrcImg.HorzScrollBar
         do begin Position := Position - 3 * Sign(WheelDelta); end;
  end;
end;
// ------------------------------------------------------------------------
// 01.03.2013
//   MouseWheel   
procedure TFormImgTools.PanelSrcImgMouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer);
begin
  if not ScrollBoxSrcImg.Focused then ScrollBoxSrcImg.SetFocus;
end;
// ------------------------------------------------------------------------
// 01.03.2013
//     
procedure TFormImgTools.ScrollBoxTrgImgMouseWheel(Sender: TObject;
  Shift: TShiftState; WheelDelta: Integer; MousePos: TPoint;
  var Handled: Boolean);
begin
  if Abs(WheelDelta) > 0
  then begin
    if MMWheelV.Checked
    then with ScrollBoxTrgImg.VertScrollBar
         do begin Position := Position - 3 * Sign(WheelDelta); end
    else with ScrollBoxTrgImg.HorzScrollBar
         do begin Position := Position - 3 * Sign(WheelDelta); end;
  end;
end;
// ------------------------------------------------------------------------
// 01.03.2013
//   MouseWheel   
procedure TFormImgTools.PanelTrgImgMouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer);
begin
  if not ScrollBoxTrgImg.Focused then ScrollBoxTrgImg.SetFocus;
end;
// ------------------------------------------------------------------------
//    ScrollBox    
// ------------------------------------------------------------------------
// 01.03.2013
//   -   
procedure TFormImgTools.MMWheelVClick(Sender: TObject);
begin
   MMWheelV.Checked := not MMWheelV.Checked;
end;
// ------------------------------------------------------------------------
// 01.03.2013
//   -   
procedure TFormImgTools.MMRulerSmoothlyClick(Sender: TObject);
begin
   MMRulerSmoothly.Checked := not MMRulerSmoothly.Checked;
   ScrollBoxSrcImg.VertScrollBar.Tracking := MMRulerSmoothly.Checked;
   ScrollBoxSrcImg.HorzScrollBar.Tracking := MMRulerSmoothly.Checked;
   ScrollBoxTrgImg.VertScrollBar.Tracking := MMRulerSmoothly.Checked;
   ScrollBoxTrgImg.HorzScrollBar.Tracking := MMRulerSmoothly.Checked;
end;

// ========================================================================
//
//        3.4
//
// ========================================================================
// 29.03.2014
//   Attention!
procedure TFormImgTools.TimerAttentionTimer(Sender: TObject);
begin
   if sttxtAttention.Color = StatusBar1.Color
   then sttxtAttention.Color := TColor(sttxtAttention.Tag)
   else sttxtAttention.Color := StatusBar1.Color;
end;
// ------------------------------------------------------------------------
// 29.03.2014
//    StatusBar1.Panels[3]   Attention!
procedure TFormImgTools.ShowAttention(LampOn    : boolean;
                                      LampColor : TColor;
                                      Msg : string);
begin
  if Msg <> '' then StatusBar1.Panels[3].Text := Msg;
  TimerAttention.Enabled := LampOn;
  sttxtAttention.Tag := integer(LampColor);
  if LampOn
  then sttxtAttention.Color := TColor(sttxtAttention.Tag)
  else sttxtAttention.Color := StatusBar1.Color;
end;

// ========================================================================
//
//        3.5
//
// ========================================================================
// ========================================================================
//
//         (  .\Gistogram )
//
// ========================================================================

// ========================================================================
//    . (unit Gistogram)
// ========================================================================
//
//         
procedure TFormImgTools.MMGistogramFullClick(Sender: TObject);
begin
   ClearStatusBar();
   // ===================================
   //   -  (unit GistogranDialog01)
   //  -    . 
   flgFuncApply  := False;
   // :
   // 0 -  
   // 1 -       
   // 2 -   ,  , 
   GistogramCMD := 1;
   FormGistogram.ShowModal;
   // ===================================
   //  -    . 
   if flgFuncApply
   then begin
      ClearImgDesc(TargetImage);       //   Image
      ShowAppTitul(1);                 //   
   end
   else ShowAppTitul(0);               //   
end;
// ------------------------------------------------------------------------
//
//      
procedure TFormImgTools.MMAutoCorrClick(Sender: TObject);
var  WRect     : Trect;
     WPnt      : TPoint;
     FrgH      : integer;
     FrgW      : integer;
begin
   if not Assigned(WHSelector)then Exit;
   //  
   if not EqualPoints(WBegPoint, WEndPoint)
   then begin
      ClearStatusBar();
      //  
      RegionSelector.RegionVisible(False);
      //------------------------------------
      //     
      FrgH := WEndPoint.Y - WBegPoint.Y + 1;
      if FrgH > WHSelector.MaxH
      then WEndPoint.Y := WBegPoint.Y + WHSelector.MaxH;
      //     
      FrgW := WEndPoint.X - WBegPoint.X + 1;
      if FrgW > WHSelector.MaxW
      then WEndPoint.X := WBegPoint.X + WHSelector.MaxW;
      //------------------------------------
      WRect := Rect(WBegPoint, WEndPoint);
      //------------------------------------
      //      Rectangle   BitMap
      //     ImgTabColor
      AreaBitMapToImgTabColor
                      (ImageMain.Picture.Bitmap, //  BitMap
                       WRect,                    //  
                       Addr(TabColorFrag)        // ImgTabColor 
                       );
      if (Length(TabColorFrag) > 0) and Assigned(WHSelector)
      then begin
         //      
         WHSelector.HideRulers;  //  
         WHSelector.ClearImage;  //   
         WPnt.X := 0;
         WPnt.Y := 0;
         //  ImgTabColor  TrgBitMap    RqPnt
         //   : (RqPnt.X >= 0)  (RqPnt.Y >= 0)
         PasteImgTabColorToBitMap
                 (Addr(TabColorFrag),           //  ImgTabColor
                  WPnt,                         //  
                  WorkImgAcFrg.Picture.Bitmap   // BitMap 
                  );
         WorkImgAcFrg.Repaint;
         WHSelector.ShowRulers;
      end;   
      // ===================================
      //   -  (unit GistogramMain)
      //  -    . 
      flgFuncApply  := False;
      // :
      // 0 -  
      // 1 -       
      // 2 -   ,  , 
      GistogramCMD := 2;
      FormGistogram.ShowModal;
      // ===================================
      //    
      SetLength(TabColorFrag, 0);
      //   
      WBegPoint := WEndPoint;
      //   
      ClearStatusBar();
      //  -    . 
      if flgFuncApply
      then begin
        ClearImgDesc(TargetImage);       //   Image
        ShowAppTitul(1);                 //   
      end
      else ShowAppTitul(0);              //   
   end
   else
     ShowAttention(True,
                   clYellow,
                   '   '
                 + '   ');
end;

// ========================================================================
//
//         (  .\EngineG01 )
//
// ========================================================================
//   TabBGR     
procedure PrerareImgTabBGR (RqImg       : TImage;
                            ptITabBGR   : ptImgTabBGR;
                            RqProgress  : TProgressBar);
//       TabBGR
const MaxImgSize = (MaxWH * MaxWH) div 2;     // (. EngineImgScale01)
var   ImgSize    : cardinal;                  //   Image
begin
    //  ()  
    RqImg.Repaint;
    //     Image
    ImgSize := RqImg.Picture.Bitmap.Height * RqImg.Picture.Bitmap.Width;
    //      
    if ImgSize > MaxImgSize
    then begin
       if MessageDlg('    '
                    + IntToStr(MaxImgSize) + ' '
                    + #13#10
                    + '     '
                    + #13#10
                    + '     .'
                    + #13#10
                    + '     ?',
          mtConfirmation, [mbYes, mbNo], 0) = mrYes
       then begin
          //  BitMap  Image  BGR- 
          ImageToImgTab (RqImg, ptITabBGR, RqProgress);
       end
       else SetLength(ptITabBGR^, 0);
    end
    else begin
        //  BitMap  Image  BGR- 
        ImageToImgTab (RqImg, ptITabBGR, RqProgress);
    end;
end;
// ------------------------------------------------------------------------
//    
procedure TFormImgTools.RunZoomForm();
begin
   //   
   ClearStatusBar();
   //  Image.     
   //    FormScaleDialog
   if PageControl1.ActivePageIndex = 0
   then begin
      //     
      SetImageSrcTrg (ImageMain, TargetImage);
   end
   else begin
       //     
      SetImageSrcTrg (TargetImage, TargetImage);
   end;
   //  
   RegionSelector.RegionVisible(False);
   FormScaleDialog.ShowModal;
   ShowAppTitul(1);             //   
   //    
   PrerareImgTabBGR (TargetImage, Addr(TrgImgTabBGR), ProgressBar1);
end;
// ------------------------------------------------------------------------
// ToolBar -    
procedure TFormImgTools.TBRZoomFormClick(Sender: TObject);
begin
   RunZoomForm();
end;
// MainMenu -    
procedure TFormImgTools.MMScaleClick(Sender: TObject);
begin
   RunZoomForm();
end;
// ------------------------------------------------------------------------
//     
procedure TFormImgTools.TrBarZoomChange(Sender: TObject);
begin
   sttxtZoomValue.Caption := IntToStr(TrBarZoom.Position) + ' %';
end;
// ------------------------------------------------------------------------
//  TrBarZoom  100%
procedure TFormImgTools.sttxtZoomValueClick(Sender: TObject);
begin
   TrBarZoom.Position := 100;
end;
// ------------------------------------------------------------------------
//   
procedure TFormImgTools.TBRZoomPlusClick(Sender: TObject);
var ImageScale : TImageScale;
    OpIndex    : byte;     // 1 : ImageMain, 2 : TargetImage
begin
   //   
   ClearStatusBar();
   //   
   ImageScale := TImageScale.Create;
   if PageControl1.ActivePageIndex = 0
   then begin
      //   
      ImageScale.ImageSrc := ImageMain;
      ImageScale.ImageTrg := ImageMain;
      OpIndex := 1;
   end
   else begin
      //   
      ImageScale.ImageSrc := TargetImage;
      ImageScale.ImageTrg := TargetImage;
      OpIndex := 2;
   end;
   //   
   ImageScale.Zoom := TrBarZoom.Position / 100;
   //  
   RegionSelector.RegionVisible(False);
   //  
   ImageScale.RunScaleHW;
   if (OpIndex = 1)
   then begin
     //    
     PrerareImgTabBGR (ImageMain, Addr(SrcImgTabBGR), ProgressBar1);
   end;
   if (OpIndex = 2)
   then begin
     //    
     PrerareImgTabBGR (TargetImage, Addr(TrgImgTabBGR), ProgressBar1);
   end;
   //   
   ImageScale.Free;
end;
// ========================================================================
//
//        
//
// ========================================================================
// ------------------------------------------------------------------------
// 24.04.2014
//  
procedure TFormImgTools.MMToGrayClick(Sender: TObject);
begin
   if PageControl1.ActivePageIndex = 0
   then begin  //   
      //  SrcBitmap  TrgBitMap  
      BitMapToGrayBitMap(ImageMain.Picture.Bitmap,
                         ImageMain.Picture.Bitmap);
      ImageMain.Repaint;
      //  BitMap  Image  BGR- 
      ImageToImgTab (ImageMain, Addr(SrcImgTabBGR), ProgressBar1);
   end
   else begin //   
      //  SrcBitmap  TrgBitMap  
      BitMapToGrayBitMap(TargetImage.Picture.Bitmap,
                         TargetImage.Picture.Bitmap);
      TargetImage.Repaint;
      //  BitMap  Image  BGR- 
      ImageToImgTab (TargetImage, Addr(TrgImgTabBGR), ProgressBar1);
   end;
end;

// ========================================================================
//               END OF IMPLEMENTATION
// ========================================================================


end.
